/*!
* WP Grid Builder Plugin
*
* @package   WP Grid Builder
* @author    Loïc Blascos
* @link      https://www.wpgridbuilder.com
* @copyright 2019-2023 Loïc Blascos
*
*/
!function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports&&module.exports?module.exports=t():e.WPGB_Tooltip=t()}(window,function(){"use strict";function e(e){e.wpgb_tooltip||e.getAttribute("aria-label")&&(this.element=e,this.event=this.leave.bind(this),this.method=this.element.getAttribute("data-method"),this.layout=this.element.getAttribute("data-layout"),this.element.wpgb_tooltip=1,"click"===this.method?this.element.addEventListener("click",this.reveal.bind(this),!1):(this.element.addEventListener("mouseenter",this.reveal.bind(this),!1),this.element.addEventListener("mouseleave",this.leave.bind(this),!1),this.element.addEventListener("focus",this.reveal.bind(this),!1),this.element.addEventListener("blur",this.leave.bind(this),!1)))}var i=function(){var e,t=document.createElement("div"),i={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in i)if(i.hasOwnProperty(e)&&void 0!==t.style[e])return t=null,i[e]}(),t=e.prototype;return t.create=function(){this.tooltip=document.createElement("div"),this.tooltip.className="wpgb-tooltip",this.tooltip.className+=this.layout?" wpgb-tooltip-"+this.layout:"",this.tooltip.textContent=this.element.getAttribute("aria-label"),this.tooltip.appendChild(document.createElement("span")),document.body.appendChild(this.tooltip)},t.reveal=function(){this.tooltip||(this.create(),this.position()),"click"===this.method&&(document.addEventListener("click",this.event,!1),window.addEventListener("resize",this.event,!1)),this.tooltip.classList.add("wpgb-show")},t.leave=function(e){var t;this.tooltip&&(t=window.getComputedStyle(this.tooltip).visibility,"click"===this.method&&"visible"!==t&&e.target===this.element||("visible"===t?(this.tooltip.addEventListener(i,this.remove.bind(this),!1),this.tooltip.classList.remove("wpgb-show")):this.remove(),"click"===this.method&&(document.removeEventListener("click",this.event,!1),window.removeEventListener("resize",this.event,!1))))},t.remove=function(e){!this.tooltip||!this.tooltip.parentNode||e&&"visibility"!==e.propertyName||(this.tooltip=this.tooltip.parentNode.removeChild(this.tooltip),this.tooltip=null)},t.position=function(){var e=this.tooltip.offsetWidth,t=this.element.getBoundingClientRect(),i=t.left+(t.width-e)/2,e=(i+e>document.body.clientWidth?i=(i=t.left-e+t.width)<0?0:i:i<0&&(i=t.left),this.tooltip.style.left=i+"px",t.left+t.width/2-i),i=t.top-this.tooltip.offsetHeight-5,s=document.querySelector("#wpadminbar");i<(s?s.clientHeight:0)&&(i=t.bottom+5,this.tooltip.firstElementChild.className="top"),this.tooltip.firstElementChild.style.left=e+"px",this.tooltip.style.top=i+window.pageYOffset+"px"},e});var WPGB_Tooltip_Init=function(){for(var e=document.querySelectorAll(".wpgb-tooltip"),t=document.querySelectorAll("[data-tooltip]"),i=0,s=e.length;i<s;i++)e[i]=document.body.removeChild(e[i]),e[i]=null;for(i=0,s=t.length;i<s;i++)new WPGB_Tooltip(t[i])};function WPGB_Dialog(e,t){var i,s,n,o,r,a,l,c,h,d;void 0===e?t():(i=document.getElementById("wpgb-admin-main"),s=document.createElement("div"),n=document.createElement("div"),o=document.createElement("h3"),r=document.createElement("span"),a=document.createElement("div"),l=document.createElement("button"),c=document.createElement("button"),s.className="wpgb-dialog-overlay",n.className="wpgb-dialog",l.className="wpgb-dialog-title",l.className="wpgb-dialog-confirm wpgb-button wpgb-green",c.className="wpgb-dialog-cancel wpgb-button wpgb-red",l.type="button",c.type="button",o.textContent=e.title,r.textContent=e.message,l.textContent=e.confirm,c.textContent=e.cancel,n.setAttribute("role","dialog"),n.setAttribute("tabindex","-1"),n.appendChild(o),n.appendChild(r),a.appendChild(c),a.appendChild(l),n.appendChild(a),s.appendChild(n),i.appendChild(s),l.focus(),s.getClientRects(),s.className+=" wpgb-show",h=function(){s&&(s.className="wpgb-dialog-overlay",setTimeout(function(){s&&(s=s.parentNode.removeChild(s),s=null)},200))},d=function(){s&&(h(),t())},document.onkeydown=function(e){s&&(e.preventDefault(),27===(e=e.keyCode)?h():13===e&&d())},document.onclick=function(e){s&&e.target.classList.contains("wpgb-dialog-overlay")&&h()},l.onclick=d,c.onclick=h)}WPGB_Tooltip_Init(),function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports&&module.exports?module.exports=t():e.WPGB_AngleInput=t()}(this,function(){"use strict";function e(e,t){this.element=e,this.value=t||0,this.events={click:this.click.bind(this),pointerDown:this.pointerDown.bind(this),pointerMove:this.pointerMove.bind(this),pointerUp:this.pointerUp.bind(this)},this.init(),this.setAngle()}var t=e.prototype;return t.init=function(){this.pivot=document.createElement("span"),this.input=document.createElement("input"),this.pivot.className="wpgb-angle-pivot",this.input.className="wpgb-angle-input",this.input.setAttribute("aria-label","°"),this.element.appendChild(this.pivot),this.element.appendChild(this.input),this.input.addEventListener("input",this.onInput.bind(this),!1),this.input.addEventListener("click",this.focusIn.bind(this),!1),this.input.addEventListener("focusout",this.focusOut.bind(this),!1),this.element.addEventListener("mousedown",this.events.pointerDown,!1)},t.pointerDown=function(e){e.target===this.pivot&&(e.preventDefault(),e.stopPropagation(),this.element.classList.add("is-dragging"),this.getAngle(e),this.setAngle(),window.addEventListener("mousemove",this.events.pointerMove,!1),window.addEventListener("mouseup",this.events.pointerUp,!1))},t.pointerMove=function(e){this.getAngle(e),this.setAngle(),document.addEventListener("click",this.events.click,!0)},t.pointerUp=function(){this.element.classList.remove("is-dragging"),window.removeEventListener("mousemove",this.events.pointerMove,!1),window.removeEventListener("mouseup",this.events.pointerUp,!1)},t.click=function(e){e.preventDefault(),e.stopPropagation(),document.removeEventListener("click",this.events.click,!0)},t.getAngle=function(e){var t=this.element.getBoundingClientRect(),i=e.clientX-(t.left+t.width/2),e=e.clientY-(t.top+t.height/2);this.value=180-Math.atan2(i,e)/Math.PI*180},t.setAngle=function(){this.value=(parseInt(this.value)+360|0)%360,this.input.value=this.value+"°",this.pivot.style.transform="rotate("+this.value+"deg)",this.fireEvent()},t.focusIn=function(e){e.target.setSelectionRange(0,e.target.value.length),this.element.classList.add("is-focused")},t.focusOut=function(){this.element.classList.remove("is-focused")},t.onInput=function(e){var t=e.target.selectionStart;this.value=parseInt(e.target.value),this.setAngle(),e.target.selectionEnd=t},t.fireEvent=function(){var e;document.createEvent?((e=document.createEvent("HTMLEvents")).initEvent("change",!1,!0),this.input.dispatchEvent(e)):(e=document.createEventObject(),this.input.fireEvent("onchange",e))},e}),function(e,t){"object"==typeof exports?module.exports=t(e):"function"==typeof define&&define.amd?define([],t.bind(e,e)):t(e)}(this,function(e){var t;return e.CSS&&e.CSS.escape?e.CSS.escape:(t=function(e){if(0==arguments.length)throw new TypeError("`CSS.escape` requires an argument.");for(var t,i=String(e),s=i.length,n=-1,o="",r=i.charCodeAt(0);++n<s;)0==(t=i.charCodeAt(n))?o+="�":o+=1<=t&&t<=31||127==t||0==n&&48<=t&&t<=57||1==n&&48<=t&&t<=57&&45==r?"\\"+t.toString(16)+" ":(0!=n||1!=s||45!=t)&&(128<=t||45==t||95==t||48<=t&&t<=57||65<=t&&t<=90||97<=t&&t<=122)?i.charAt(n):"\\"+i.charAt(n);return o},e.CSS||(e.CSS={}),e.CSS.escape=t)}),function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports&&module.exports?module.exports=t():e.WPGB_Select=t()}(this,function(){"use strict";function e(e,t){if(this.element=e,this.element.wpgb_select)return!1;this.async=e.getAttribute("data-async"),this.search=e.getAttribute("data-search"),this.options=this.extend(t,i),this.request=null,this.scrollTop=0,this.element.wpgb_select=!0,this.buildPlaceholder(),this.init()}var i={url:null,lang:null,nonce:null,action:null,search:null,searching:null,noresult:null,error:null},t=e.prototype;return t.init=function(){this.events={keydown:this.keydown.bind(this),position:this.setPosition.bind(this),close:this.close.bind(this)},this.selection&&this.selection.addEventListener("click",this.removeSelectedItems.bind(this)),this.clearSelect&&this.clearSelect.addEventListener("click",this.clearSelection.bind(this)),this.element.onchange=this.onChange.bind(this),this.holder.addEventListener("click",this.open.bind(this),!1),this.element.addEventListener("click",this.open.bind(this),!1)},t.extend=function(e,t){if(e)for(var i in t)t.hasOwnProperty(i)&&e.hasOwnProperty(i)&&(t[i]=e[i]);return t},t.dispatchEvent=function(e,t){var i;document.createEvent?((i=document.createEvent("HTMLEvents")).initEvent(t,!0,!0),e.dispatchEvent(i)):((i=document.createEventObject()).eventType=t,e.fireEvent("on"+i.eventType,i))},t.bindEvents=function(e){e=(e=void 0===e||!!e)?"addEventListener":"removeEventListener",window[e]("keydown",this.events.keydown,!1),window[e]("scroll",this.events.position,!1),window[e]("resize",this.events.close,!1),document[e]("click",this.events.close,!1)},t.removeItems=function(e){for(;e.firstChild;){var t=e.firstChild;e.removeChild(t),0}},t.removeDiacritics=function(e){return String.prototype.normalize?e.normalize("NFD").replace(/[\u0300-\u036f]/g,""):e},t.getScrollParent=function(e){for(var t=e.parentElement;t!==document.body;){var i=getComputedStyle(t,null),s=i.getPropertyValue("overflow");if(s+=i.getPropertyValue("overflow-y"),/(auto|scroll)/.test(s))return t;t=t.parentElement}},t.open=function(e){e.preventDefault(),this.select?this.remove():(this.element===e.target&&e.stopImmediatePropagation(),this.buildList(),this.wrapper.classList.add("wpgb-select-open"),this.select.id="wpgb-select-"+this.element.name,document.body.appendChild(this.select),this.scrollParent=this.getScrollParent(this.element),this.scrollParent&&(setTimeout(function(){this.scrollParent.classList.add("wpgb-disable-scroll")}.bind(this),32),setTimeout(this.setPosition.bind(this),32)),this.setPosition(),this.results.scrollTop=this.scrollTop,this.input&&this.input.focus(),this.bindEvents(!0))},t.close=function(e){!this.select||"resize"!==e.type&&(this.select.contains(e.target)||this.holder.contains(e.target))||this.remove()},t.remove=function(){this.wrapper.classList.remove("wpgb-select-open"),this.scrollTop=this.input&&this.input.value?0:this.results.scrollTop,this.select=document.body.removeChild(this.select),this.select=null,this.scrollParent&&this.scrollParent.classList.remove("wpgb-disable-scroll"),this.bindEvents(!1)},t.displayMessage=function(e,t){var i=this.results.querySelector(".wpgb-select-message"),s=this.results.querySelector(".wpgb-select-option");i&&(i.parentNode.removeChild(i),i=null),t&&s||this.removeItems(this.results),e&&((i=document.createElement("LI")).classList.add("wpgb-select-message"),i.textContent=this.options[e],t&&s?this.results.insertBefore(i,this.results.firstChild):this.results.appendChild(i),this.setPosition())},t.setPosition=function(){var e,t,i;this.select&&(this.select.classList.remove("wpgb-select-top-position"),this.holder.classList.remove("wpgb-select-top-position"),e=this.holder.getBoundingClientRect(),i=(this.input?e.top:e.bottom)+window.pageYOffset,(i=this.input&&this.element.multiple&&0<this.selection.childElementCount?i+this.holder.clientHeight:i)+this.select.clientHeight>window.innerHeight+window.pageYOffset&&(t=(this.input?e.bottom:e.top)+window.pageYOffset-this.select.clientHeight,i=0<=(t=this.input&&this.element.multiple&&0<this.selection.childElementCount?t-this.holder.clientHeight:t)?t:i,this.select.classList[0<=t?"add":"remove"]("wpgb-select-top-position"),this.holder.classList[0<=t?"add":"remove"]("wpgb-select-top-position")),this.select.style.left=e.left+"px",this.select.style.top=i+"px")},t.keydown=function(e){this.select&&27===e.keyCode&&this.remove()},t.buildPlaceholder=function(){this.wrapper=document.createElement("DIV"),this.holder=document.createElement("DIV"),this.placeholder=document.createElement("SPAN"),this.wrapper.style.width=this.element.style.width,this.wrapper.classList.add("wpgb-select-wrapper"),this.holder.classList.add("wpgb-select"),this.placeholder.classList.add("wpgb-select-placeholder"),this.holder.appendChild(this.placeholder),this.addSelection(),this.wrapper.appendChild(this.holder),this.element.parentNode.insertBefore(this.wrapper,this.element.nextSibling),this.wrapper.insertBefore(this.element,this.wrapper.firstChild)},t.addSelection=function(){var e;this.element.multiple?(e=this.element.querySelector("option"),this.placeholder.textContent=e?e.textContent:null,this.selection=document.createElement("UL"),this.selection.classList.add("wpgb-selection"),this.holder.appendChild(this.selection),this.addSelectedItems()):(e=Math.max(0,this.element.selectedIndex),this.placeholder.classList.add("wpgb-select-selected"),this.placeholder.textContent=this.element[e]?this.element[e].textContent:null,this.element[0]&&!this.element[0].value&&(this.placeholder.classList[0<e?"add":"remove"]("wpgb-select-selected"),this.clearSelect=document.createElement("SPAN"),this.clearSelect.classList.add("wpgb-select-clear"),this.holder.appendChild(this.clearSelect),0===e)&&(this.clearSelect.style.display="none"))},t.addSelectedItems=function(){this.removeItems(this.selection);for(var e=this.element.querySelectorAll("option"),t=document.createDocumentFragment(),i=0,s=e.length;i<s;i++){var n,o,r=e[i];r.selected&&(n=document.createElement("LI"),(o=document.createElement("SPAN")).classList.add("wpgb-selected-remove"),n.classList.add("wpgb-selected-item"),n.textContent=r.textContent,n.wpgb_value=r.value,n.insertBefore(o,n.firstChild),t.appendChild(n))}this.selection.appendChild(t),this.placeholder.style.display=0<this.selection.childElementCount?"none":"block"},t.removeSelectedItems=function(e){var t,e=e.target;e.classList.contains("wpgb-selected-remove")&&(e=e.parentElement,t=this.element.querySelector('[value="'+CSS.escape(e.wpgb_value)+'"]'),e&&(e=e.parentElement.removeChild(e),t.selected=e=null),this.placeholder.style.display=0<this.selection.childElementCount?"none":"block",this.dispatchEvent(this.element,"change"))},t.clearSelection=function(e){e&&(e.preventDefault(),e.stopPropagation()),this.element.value=null,this.placeholder.textContent=this.element[0].textContent,this.clearSelect.style.display="none",this.placeholder.classList.remove("wpgb-select-selected"),this.select&&this.remove(),e&&this.dispatchEvent(this.element,"change")},t.getItems=function(e,t){var i;if(e||(i=document.createDocumentFragment(),t=this.results=document.createElement("UL"),e=this.element.children,t.classList.add("wpgb-select-results"),i.appendChild(t),e.length&&(1!==e.length||this.element[0].value||!this.placeholder))||this.async||this.displayMessage("noresult"),!this.async)for(var s=0,n=e.length;s<n;s++){var o,r,a,l,c=e[s];if(!(c instanceof HTMLElement))return null;"optgroup"===c.localName?(o=document.createElement("LI"),r=document.createElement("UL"),a=document.createElement("STRONG"),l=this.getItems(c.children,r),o.classList.add("wpgb-select-group"),r.classList.add("wpgb-select-group"),a.classList.add("wpgb-select-label"),a.textContent=c.label,o.appendChild(a),o.appendChild(l),t.appendChild(o)):"option"===c.localName&&(o=document.createElement("LI"),""!==c.value)&&(o.classList.add("wpgb-select-option"),o.classList[c.disabled?"add":"remove"]("wpgb-select-disabled"),o.classList[c.selected?"add":"remove"]("wpgb-selected"),o.textContent=c.textContent,o.wpgb_value=c.value,o.disabled=!!c.disabled||null,t.appendChild(o))}return t},t.populateList=function(e){if(!e||e.length<=0)this.displayMessage("noresult");else{var t,i,s,n,o;if(Array.isArray(e))t=this.populateItem(e);else for(var r in t=document.createDocumentFragment(),e)e.hasOwnProperty(r)&&(i=document.createElement("LI"),s=document.createElement("UL"),n=document.createElement("STRONG"),o=this.populateItem(e[r]),i.classList.add("wpgb-select-group"),s.classList.add("wpgb-select-group"),n.classList.add("wpgb-select-label"),n.textContent=r,s.appendChild(o),i.appendChild(n),i.appendChild(s),t.appendChild(i));this.results.appendChild(t),this.setPosition()}},t.populateItem=function(e){for(var t=document.createDocumentFragment(),i=0,s=e.length;i<s;i++){var n=e[i],o=document.createElement("LI"),r=this.element.querySelector('[value="'+CSS.escape(n.value)+'"]');o.classList.add("wpgb-select-option"),o.classList[n.disabled?"add":"remove"]("wpgb-select-disabled"),o.classList[r&&r.selected?"add":"remove"]("wpgb-selected"),o.innerHTML=n.content||null,o.wpgb_value=n.value||null,o.disabled=!!n.disabled||null,o.option=n.option,t.appendChild(o)}return t},t.buildList=function(){var e;this.select=document.createElement("DIV"),this.select.classList.add("wpgb-select-container"),this.select.classList[this.selection&&0<this.selection.childElementCount?"add":"remove"]("wpgb-select-multiple"),this.select.style.width=this.wrapper.clientWidth+"px",(this.search||this.async)&&(e=this.async?"searchAsync":"searchString",this.input=document.createElement("INPUT"),this.input.classList.add("wpgb-select-search"),this.input.addEventListener("keyup",this[e].bind(this),!1),this.select.classList.add("wpgb-select-has-search"),this.select.appendChild(this.input),this.addSearchIcon()),this.select.appendChild(this.getItems()),this.results.addEventListener("click",this.selectItem.bind(this),!1),this.async&&this.displayMessage("search")},t.addSearchIcon=function(){var e="http://www.w3.org/2000/svg",t=document.createElementNS(e,"svg"),e=document.createElementNS(e,"path");t.setAttribute("class","wpgb-select-icon"),t.setAttribute("viewBox","0 0 16 16"),t.setAttribute("width",13),t.setAttribute("height",13),e.setAttributeNS(null,"d","M12.7 11.3c0.9-1.2 1.4-2.6 1.4-4.2C14.1 3.2 11 0 7.1 0S0 3.2 0 7.1c0 3.9 3.2 7.1 7.1 7.1 1.6 0 3.1-0.5 4.2-1.4l3 3c0.2 0.2 0.5 0.3 0.7 0.3s0.5-0.1 0.7-0.3c0.4-0.4 0.4-1 0-1.4L12.7 11.3zM7.1 12.1C4.3 12.1 2 9.9 2 7.1S4.3 2 7.1 2s5.1 2.3 5.1 5.1S9.9 12.1 7.1 12.1z"),t.appendChild(e),this.select.appendChild(t)},t.selectItem=function(e){for(var t=e.target;"UL"!==t.tagName&&"LI"!==t.tagName;)t=t.parentElement;t.disabled||"LI"===t.tagName&&t.hasOwnProperty("wpgb_value")&&(this.addOption(t),this.element.multiple?(e=this.element.querySelector('[value="'+CSS.escape(t.wpgb_value)+'"]'))&&(e.selected=!e.selected||null):this.element.value=t.wpgb_value,this.remove(),this.dispatchEvent(this.element,"change"))},t.onChange=function(){if(this.element.multiple)this.addSelectedItems(),this.placeholder.style.display=0<this.selection.childElementCount?"none":"block";else{if(this.clearSelect){if(this.element.value===this.element[0].value)return void this.clearSelection();this.clearSelect.style.display=""!==this.element.value?"block":"none",this.placeholder.classList[""!==this.element.value?"add":"remove"]("wpgb-select-selected")}var e=this.element.selectedIndex;this.placeholder.textContent=-1<e?this.element[e].textContent:null}},t.addOption=function(e){var t;this.element.querySelector('[value="'+CSS.escape(e.wpgb_value)+'"]')||((t=document.createElement("OPTION")).value=e.wpgb_value,t.textContent=e.option||e.textContent,this.element.appendChild(t))},t.searchString=function(){this.found=0;var e=this.removeDiacritics(this.input.value).toLowerCase();this.searchItems(e,this.results),this.results.scrollTop=this.scrollTop,this.displayMessage(this.found<=0?"noresult":null,!0),this.setPosition()},t.searchItems=function(e,t){if(t&&t.children.length){for(var i=0,s=0,n=(t=t.children).length;s<n;s++){var o,r=t[s];r.classList.contains("wpgb-select-option")?-1<this.removeDiacritics(r.textContent).toLowerCase().indexOf(e)?(r.style.display="block",this.found++,i++):r.style.display="none":(o=this.searchItems(e,r),(r=r.parentElement)&&r.classList.contains("wpgb-select-group")&&(r.style.display=o<=0?"none":"block"))}return i}},t.searchAsync=function(){var e,t={data:this.element.getAttribute("data-post")||"",search:this.input.value,lang:this.options.lang,nonce:this.options.nonce,action:this.options.action,method:this.async,object:"content"},i=[];for(e in t)t.hasOwnProperty(e)&&i.push(encodeURIComponent(e)+"="+encodeURIComponent(t[e]));this.request&&this.request.abort(),this.input.value?(this.displayMessage("searching",!0),this.request=new XMLHttpRequest,this.request.open("POST",ajaxurl),this.request.setRequestHeader("Content-type","application/x-www-form-urlencoded"),this.request.onload=function(){var e;200<=this.request.status&&this.request.status<400&&(e=JSON.parse(this.request.responseText)).success?(this.removeItems(this.results),this.populateList(e.content)):this.displayMessage("error")}.bind(this),this.request.onerror=function(){this.displayMessage("error")},this.request.send(i.join("&"))):this.displayMessage("search")},e});var WPGB_Popup_Timer,WPGB_Select_Init=function(){for(var e=document.querySelectorAll("#wpgb select"),t=wpgb_select_L10n,i=0,s=e.length;i<s;i++)new WPGB_Select(e[i],{url:ajaxurl,lang:wpgb_L10n.lang,nonce:wpgb_L10n.search,action:"wpgb_search",search:t.search,searching:t.searching,noresult:t.no_result,error:t.error})},WPGB_Gradient_Init=(document.addEventListener("DOMContentLoaded",function(){WPGB_Select_Init()}),!function(r){"undefined"!=typeof Color&&(Color.fn.toString=function(){var e;return this._alpha<1?this.toCSS("rgba",this._alpha).replace(/\s+/g,""):(e=parseInt(this._color,10).toString(16),this.error?"":"#"+(e=e.length<6?("00000"+e).substr(-6):e))},r.widget("wp.wpColorPicker",r.wp.wpColorPicker,{_create:function(){var i,e;r.support.iris&&(this.options.__?(e=(i=this).element,r.extend(i.options,e.data()),i.close=r.proxy(i.close,i),i.initialValue=e.val(),e.addClass("wp-color-picker").hide().wrap('<div class="wp-picker-container" />'),i.wrap=e.parent(),i.toggler=r('<a tabindex="0" class="wp-color-result" />').insertBefore(e).css({backgroundColor:i.initialValue}).attr("title",wpgb_colorPicker_L10n.pick).attr("data-current",wpgb_colorPicker_L10n.current),i.pickerContainer=r('<div class="wp-picker-holder" />').insertAfter(e),i.button=r('<input type="button" class="button button-small hidden" />'),i.options.defaultColor?i.button.addClass("wp-picker-default").val(wpgb_colorPicker_L10n.default).attr("aria-label",wpgb_colorPicker_L10n.default):i.button.addClass("wp-picker-clear").val(wpgb_colorPicker_L10n.clear).attr("aria-label",wpgb_colorPicker_L10n.clear),e.wrap('<span class="wp-picker-input-wrap" />').after(i.button),e.iris({wpgb:1,target:i.pickerContainer,hide:i.options.hide,width:i.options.width,mode:i.options.mode,palettes:i.options.palettes,change:function(e,t){i.options.alpha?i.toggler.find("span").css({width:"100%",height:"100%",position:"absolute",top:0,left:0,"border-top-left-radius":"3px","border-bottom-left-radius":"3px",background:t.color.toString()}):i.toggler.css({backgroundColor:t.color.toString()}),"function"==typeof i.options.change&&i.options.change.call(this,e,t)}}),e.val(i.initialValue),i._addListeners(),i.options.hide||i.toggler.click()):this._super())},_addListeners:function(){var t=this;t.wrap.on("click.wpcolorpicker",function(e){e.stopPropagation()}),t.toggler.on("click",function(){t.toggler.hasClass("wp-picker-open")?t.close():t.open()}),t.element.on("change",function(e){""!==r(this).val()&&!t.element.hasClass("iris-error")||((t.options.alpha?(t.toggler.removeAttr("style"),t.toggler.find("span")):t.toggler).css("backgroundColor",""),"function"!=typeof t.options.clear)||t.options.clear.call(this,e)}),t.toggler.on("keyup",function(e){13!==e.keyCode&&32!==e.keyCode||(e.preventDefault(),t.toggler.trigger("click").next().focus())}),t.button.on("click",function(e){r(this).hasClass("wp-picker-clear")?(t.element.val(""),(t.options.alpha?(t.toggler.removeAttr("style"),t.toggler.find("span")):t.toggler).css("backgroundColor",""),"function"==typeof t.options.clear&&t.options.clear.call(this,e)):r(this).hasClass("wp-picker-default")&&t.element.val(t.options.defaultColor).change()})}}),r.widget("a8c.iris",r.a8c.iris,{_create:function(){var i,e,t,s,n,o;this._super(),this.options.wpgb&&(this.options.alpha=this.element.data("alpha")||!1,this.picker.find(".iris-square-value").attr("aria-label","iris"),this.element.is(":input")||(this.options.alpha=!1),void 0!==this.options.alpha)&&this.options.alpha&&(e=(i=this).element,s=(t=r('<div class="iris-slider iris-strip iris-alpha-slider"><div class="iris-alpha-slider-bg"></div><div class="iris-slider-offset iris-slider-offset-alpha"></div></div>').insertAfter(i.picker.find(".iris-slider.iris-strip"))).find(".iris-slider-offset-alpha"),t={aContainer:t,aSlider:s},void 0!==e.data("custom-width")?i.options.customWidth=parseInt(e.data("custom-width"))||0:i.options.customWidth=100,i.options.defaultWidth=e.width(),(i._color._alpha<1||-1!=i._color.toString().indexOf("rgb"))&&e.width(parseInt(i.options.defaultWidth+i.options.customWidth)),r.each(t,function(e,t){i.controls[e]=t}),i.controls.square.css({"margin-right":"0"}),s=i.picker.width()-i.controls.square.width()-20,o=s/2-(n=s/6),r.each(["aContainer","strip"],function(e,t){i.controls[t].width(o).css({"margin-left":n+"px"})}),i._initControls(),i._change())},_initControls:function(){var i;this._super(),this.options.wpgb&&this.options.alpha&&(i=this).controls.aSlider.slider({orientation:"vertical",min:0,max:100,step:1,value:parseInt(100*i._color._alpha),slide:function(e,t){i._color._alpha=parseFloat(t.value/100),i._change.apply(i,arguments)}})},_change:function(){this._super();var e,t,i,s,n,o=this,r=o.element;this.options.wpgb&&this.options.alpha&&(e=o.controls,t=parseInt(100*o._color._alpha),i=["rgb("+(i=o._color.toRgb()).r+","+i.g+","+i.b+") 0%","rgba("+i.r+","+i.g+","+i.b+", 0) 100%"],s=o.options.defaultWidth,n=o.options.customWidth,e.aContainer.find("div").first().css({background:"linear-gradient(to bottom, "+i.join(", ")+")"}),e.aSlider.slider("value",t),o._color._alpha<1?(e.strip.attr("style",e.strip.attr("style").replace(/rgba\\(([0-9]+,)(\\s+)?([0-9]+,)(\\s+)?([0-9]+)(,(\\s+)?[0-9\\.]+)\\)/g,"rgb($1$3$5)")),r.width(parseInt(s+n))):r.width(s)),!r.data("reset-alpha")&&1||o.picker.find(".iris-palette-container").on("click.palette",".iris-palette",function(){o._color._alpha=1,o.active="external",o._change()})},_addInputListeners:function(s){function e(e){var t=new Color(s.val()),i=s.val();s.removeClass("iris-error"),t.error?""!==i&&s.addClass("iris-error"):t.toString()===n._color.toString()||"keyup"===e.type&&i.match(/^[0-9a-fA-F]{3}$/)||n._setOption("color",t.toString())}var n=this;s.on("change",e).on("keyup",n._debounce(e,100)),n.options.hide&&s.on("focus",function(){n.show()})}}))}(jQuery),!function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports&&module.exports?module.exports=t():e.WPGB_Gradient=t()}(this,function(){"use strict";function e(e,t){if(e.wpgb_gradient)return!1;this.i18n=t,this.DOM={},this.points={},this.element=e,this.centerX=50,this.centerY=50,this.events={open:this.open.bind(this),close:this.close.bind(this),clear:this.clear.bind(this),resize:this.resize.bind(this),togglePicker:this.togglePicker.bind(this),showPresets:this.showPresets.bind(this),createPoint:this.createPoint.bind(this),reversePoints:this.reversePoints.bind(this),setColorType:this.setColorType.bind(this),setGradientType:this.setGradientType.bind(this),setGradientCenter:this.setGradientCenter.bind(this),deletePoint:this.deletePoint.bind(this),onFocus:this.onFocus.bind(this),onInput:this.onInput.bind(this)},this.element.wpgb_gradient=!0,this.init()}var s=["linear-gradient(19deg, #21D4FD 0%, #B721FF 100%)","linear-gradient(0deg, #08AEEA 0%, #2AF598 100%)","linear-gradient(90deg, #FEE140 0%, #FA709A 100%)","linear-gradient(62deg, #8EC5FC 0%, #E0C3FC 100%)","linear-gradient(19deg, #FAACA8 0%, #DDD6F3 100%)","linear-gradient(62deg, #FBAB7E 0%, #F7CE68 100%)","linear-gradient(0deg, #D9AFD9 0%, #97D9E1 100%)","linear-gradient(90deg, #00DBDE 0%, #FC00FF 100%)","linear-gradient(132deg, #F4D03F 0%, #16A085 100%)","linear-gradient(160deg, #0093E9 0%, #80D0C7 100%)","linear-gradient(90deg, #74EBD5 0%, #9FACE6 100%)","linear-gradient(270deg, #FAD961 0%, #F76B1C 99%)","linear-gradient(45deg, #FA8BFF 0%, #2BD2FF 52%, #2BFF88 90%)","linear-gradient(45deg, #FBDA61 0%, #FF5ACD 100%)","linear-gradient(135deg, #8BC6EC 0%, #9599E2 100%)","linear-gradient(180deg, #A9C9FF 0%, #FFBBEC 100%)","linear-gradient(19deg, #3EECAC 0%, #EE74E1 100%)","linear-gradient(43deg, #4158D0 0%, #C850C0 46%, #FFCC70 100%)","linear-gradient(45deg, #85FFBD 0%, #FFFB7D 100%)","linear-gradient(90deg, #eea2a2 0%, #bbc1bf 19%, #57c6e1 42%, #b49fda 79%, #7ac5d8 100%)","linear-gradient(0deg, #fcc5e4 0%, #fda34b 15%, #ff7882 35%, #c8699e 52%, #7046aa 71%, #0c1db8 87%, #020f75 100%)","linear-gradient(0deg, #dbdcd7 0%, #dddcd7 24%, #e2c9cc 30%, #e7627d 46%, #b8235a 59%, #801357 71%, #3d1635 84%, #1c1a27 100%)","linear-gradient(0deg, #505285 0%, #585e92 12%, #65689f 25%, #7474b0 37%, #7e7ebb 50%, #8389c7 62%, #9795d4 75%, #a2a1dc 87%, #b5aee4 100%)","linear-gradient(0deg, #4fb576 0%, #44c489 30%, #28a9ae 46%, #28a2b7 59%, #4c7788 71%, #6c4f63 86%, #432c39 100%)","linear-gradient(0deg, #f43b47 0%, #453a94 100%)","linear-gradient(0deg, #e4afcb 0%, #b8cbb8 0%, #b8cbb8 0%, #e2c58b 30%, #c2ce9c 64%, #7edbdc 100%)","linear-gradient(0deg, #d5d4d0 0%, #d5d4d0 1%, #eeeeec 31%, #efeeec 75%, #e9e9e7 100%)","linear-gradient(0deg, #0fd850 0%, #f9f047 100%)","linear-gradient(90deg, #00dbde 0%, #fc00ff 100%)","linear-gradient(135deg, #FDEB71 10%, #F8D800 100%)","linear-gradient(135deg, #ABDCFF 10%, #0396FF 100%)","linear-gradient(135deg, #FEB692 10%, #EA5455 100%)","linear-gradient(135deg, #A0FE65 10%, #FA016D 100%)","linear-gradient(135deg, #FFCF71 10%, #2376DD 100%)","linear-gradient(135deg, #6B73FF 10%, #000DFF 100%)","linear-gradient(135deg, #FFF3B0 10%, #CA26FF 100%)","linear-gradient(135deg, #FFDB01 10%, #0E197D 100%)","linear-gradient(135deg, #92FFC0 10%, #002661 100%)","linear-gradient(135deg, #EECE13 10%, #B210FF 100%)","linear-gradient(135deg, #F0FF00 10%, #58CFFB 100%)"],t=e.prototype;return t.init=function(){this.buildMarkup(),this.getMarkup(),this.addEvents(),this.addPicker(),this.addAngle(),this.addCenter()},t.render=function(){this.removePoints(),this.getColor(),"solid"===this.colorType?this.showPicker():(this.setCanvas(),this.addPoints(),this.setAngle()),this.DOM.holder&&(this.setButtons(),this.DOM.holder.style.display="solid"===this.colorType?"none":"block")},t.dispatchEvent=function(e,t){var i;document.createEvent?((i=document.createEvent("HTMLEvents")).initEvent(t,!0,!0),e.dispatchEvent(i)):((i=document.createEventObject()).eventType=t,e.fireEvent("on"+i.eventType,i))},t.buildMarkup=function(){var e="",t=this.element.getAttribute("data-gradient");t&&(e=(e=e+'<ul class="wpgb-color-types"><li data-type="solid">'+this.i18n.solid+"</li>")+'<li data-type="gradient">'+this.i18n.gradient+"</li></ul>"),e+='<div class="wpgb-color-inner">',e=(e=t?(e=(e=(e=(e=(e=(e=(e=(e=(e=(e=(e=(e+='<div class="wpgb-gradient-holder"><div class="wpgb-gradient-preview-holder"><div class="wpgb-gradient-preview"></div><div class="wpgb-gradient-angle"></div><div class="wpgb-gradient-center"></div>')+'<ul class="wpgb-gradient-types"><li data-type="linear">'+this.i18n.linear+"</li>")+'<li data-type="radial">'+this.i18n.radial+"</li>")+'<li class="wpgb-gradient-reverse" title="'+this.i18n.reverse+'">')+'<svg class="wpgb-reverse-icon"><use xmlns:xlink="http://www.w3.org/1999/xlink/" xlink:href="'+this.i18n.icons.reverse+'"></use></svg>')+'</li><li class="wpgb-gradient-presets" title="'+this.i18n.presets+'">')+'<svg class="wpgb-switch-icon"><use xmlns:xlink="http://www.w3.org/1999/xlink/" xlink:href="'+this.i18n.icons.presets+'"></use></svg></li></ul></div>')+'<div class="wpgb-gradient-point-controls"><input class="wpgb-gradient-point-position" title="'+this.i18n.position+'">')+'<span class="wpgb-gradient-point-delete" title="'+this.i18n.delete+'">')+'<svg class="wpgb-delete-icon"><use xmlns:xlink="http://www.w3.org/1999/xlink/" xlink:href="'+this.i18n.icons.delete+'"></use></svg>')+'</span><span class="wpgb-gradient-point-color" title="'+this.i18n.edit+'">')+'<svg class="wpgb-color-icon"><use xmlns:xlink="http://www.w3.org/1999/xlink/" xlink:href="'+this.i18n.icons.edit+'"></use></svg></span>')+'</div><canvas class="wpgb-gradient-canvas" title="'+this.i18n.add+'"></canvas><ul class="wpgb-gradient-points"></ul></div>':e)+('<input class="wpgb-color-iris" data-alpha="'+this.element.getAttribute("data-alpha")+'" aria-label="'+this.i18n.color)+'"></div>',this.DOM.wrapper=document.createElement("DIV"),this.DOM.wrapper.className="wpgb-color-holder",this.DOM.wrapper.innerHTML=e,this.element.appendChild(this.DOM.wrapper)},t.getMarkup=function(){this.DOM.input=this.element.querySelector(".wpgb-input"),this.DOM.picker=this.element.querySelector(".wpgb-color-picker"),this.DOM.clear=this.element.querySelector(".wpgb-color-clear"),this.DOM.preview=this.element.querySelector(".wpgb-color-picker-preview"),this.DOM.iris=this.element.querySelector(".wpgb-color-iris"),this.DOM.colorTypes=this.element.querySelector(".wpgb-color-types"),this.DOM.holder=this.element.querySelector(".wpgb-gradient-holder"),this.DOM.gradient=this.element.querySelector(".wpgb-gradient-preview"),this.DOM.canvas=this.element.querySelector(".wpgb-gradient-canvas"),this.DOM.points=this.element.querySelector(".wpgb-gradient-points"),this.DOM.color=this.element.querySelector(".wpgb-gradient-point-color"),this.DOM.delete=this.element.querySelector(".wpgb-gradient-point-delete"),this.DOM.position=this.element.querySelector(".wpgb-gradient-point-position"),this.DOM.gradientTypes=this.element.querySelector(".wpgb-gradient-types"),this.DOM.angle=this.element.querySelector(".wpgb-gradient-angle"),this.DOM.center=this.element.querySelector(".wpgb-gradient-center"),this.DOM.reverse=this.element.querySelector(".wpgb-gradient-reverse"),this.DOM.presets=this.element.querySelector(".wpgb-gradient-presets")},t.addEvents=function(){this.DOM.picker.addEventListener("click",this.events.open,!1),this.DOM.clear.addEventListener("click",this.events.clear,!1),this.DOM.holder&&(this.DOM.canvas.addEventListener("click",this.events.createPoint,!1),this.DOM.presets.addEventListener("click",this.events.showPresets,!1),this.DOM.reverse.addEventListener("click",this.events.reversePoints,!1),this.DOM.colorTypes.addEventListener("click",this.events.setColorType,!1),this.DOM.gradient.addEventListener("click",this.events.setGradientCenter,!1),this.DOM.gradientTypes.addEventListener("click",this.events.setGradientType,!1),this.DOM.color.addEventListener("click",this.events.togglePicker,!1),this.DOM.delete.addEventListener("click",this.events.deletePoint,!1),this.DOM.position.addEventListener("click",this.events.onFocus,!1),this.DOM.position.addEventListener("input",this.events.onInput,!1))},t.open=function(e){e.preventDefault(),"block"===this.DOM.wrapper.style.display?this.close():(window.addEventListener("resize",this.events.resize,!1),document.addEventListener("click",this.events.close,!1),this.DOM.wrapper.style.display="block",this.DOM.clear.style.display="inline-block",this.render())},t.close=function(e){if(e&&e.target!==this.element&&e.target!==this.DOM.color&&"wpgb-color-picker"!==e.target.className&&e.target.parentNode&&"wpgb-color-picker"!==e.target.parentNode.className&&("gradient"===this.colorType&&"block"===this.DOM.iris.style.display||this.DOM.presetsHolder))this.hidePicker();else{if(e)for(var t=e.target;t;){if(t===this.element)return;t=t.parentElement}document.body.contains(this.element)&&(this.hidePicker(),this.DOM.clear.style.display=this.DOM.wrapper.style.display="none"),window.removeEventListener("resize",this.events.resize,!1),document.removeEventListener("click",this.events.close,!1)}},t.clear=function(e){this.DOM.input.value="",this.dispatchEvent(this.DOM.input,"change"),this.render()},t.resize=function(){"solid"!==this.colorType&&(this.setCanvas(),this.setGradient())},t.getColor=function(){var e=this.DOM.input.value;-1<e.search("linear-gradient")||-1<e.search("radial-gradient")?(this.colorType="gradient",this.gradientType=-1<e.search("linear-gradient")?"linear":"radial",this.getGradient(e)):(this.colorType="solid",this.color=this.solidColor=this.DOM.preview.style.background=e),this.DOM.colorTypes||"gradient"!==this.colorType||(this.points={},this.DOM.input.value="",this.getColor())},t.getGradient=function(e){if(this.index=0,(e=e.match(/\((.*)\)/))[1]){for(var t=e[1].split(/,\s?(?![^(]*\))/),i=0;i<t.length;i++){var s=t[i].trim().split(/\s+\s?(?![^(]*\))/);0===i?"linear"===this.gradientType?this.angle=parseInt(s[0]):this.DOM.center&&(this.centerX=s[2]?parseInt(s[2]):50,this.centerY=s[3]?parseInt(s[3]):50,this.DOM.center.style.left=this.centerX+"%",this.DOM.center.style.top=this.centerY+"%"):(this.points[this.index]={color:s[0]||"#fff",position:s[1]?parseFloat(s[1])/100:0},this.index++)}this.point=this.points[0]}},t.setButtons=function(){for(var e,t=this.DOM.colorTypes.querySelectorAll("[data-type]"),i=this.DOM.gradientTypes.querySelectorAll("[data-type]"),s=0;s<t.length;s++)e=t[s].getAttribute("data-type"),t[s].classList[e===this.colorType?"add":"remove"]("wpgb-color-type-active");for(s=0;s<i.length;s++)e=i[s].getAttribute("data-type"),i[s].classList[e===this.gradientType?"add":"remove"]("wpgb-gradient-type-active");this.element.setAttribute("data-color-type",this.colorType||"none"),this.element.setAttribute("data-gradient-type",this.gradientType||"none")},t.setColorType=function(e){if("LI"===e.target.tagName){if(this.colorType=e.target.getAttribute("data-type"),"solid"===this.colorType){for(var t in this.points)if(this.points.hasOwnProperty(t)){this.DOM.input.value=this.solidColor||"";break}}else this.DOM.input.value=this.gradientColor=this.gradientColor||s[0];this.dispatchEvent(this.DOM.input,"change"),this.hidePicker(),this.render()}},t.setGradientType=function(e){"LI"===e.target.tagName&&(this.gradientType=e.target.getAttribute("data-type")||"linear",this.setGradient(),this.render())},t.onFocus=function(e){e.target.setSelectionRange(0,e.target.value.length)},t.onInput=function(e){var t=parseInt(e.target.selectionStart),i=Math.round(Math.min(Math.max(parseInt(e.target.value)||0,0),100));this.point.position=i/100,this.point.DOM.style.left=i+"%",this.setGradient(),e.target.value=i+"%",e.target.selectionEnd=t},t.addAngle=function(){this.DOM.angle&&(this.angleInput=new WPGB_AngleInput(this.DOM.angle),this.angleInput.input.onchange=function(){this.angle=this.angleInput.value,this.setGradient()}.bind(this))},t.setAngle=function(){this.angleInput.value=this.angle,this.angleInput.setAngle()},t.addCenter=function(){var i;this.DOM.center&&(i=this,jQuery(this.DOM.center).draggable({scroll:!1,containment:"parent",start:function(){i.DOM.center.classList.add("is-dragging")},drag:function(e,t){i.centerX=Math.round(100*Math.min(Math.max(t.position.left/i.DOM.gradient.clientWidth,0),1)),i.centerY=Math.round(100*Math.min(Math.max(t.position.top/i.DOM.gradient.clientHeight,0),1)),t.position.left=i.centerX/100*i.DOM.gradient.clientWidth,t.position.top=i.centerY/100*i.DOM.gradient.clientHeight,i.setGradient()},stop:function(e,t){i.centerX=Math.round(100*Math.min(Math.max(t.position.left/i.DOM.gradient.clientWidth,0),1)),i.centerY=Math.round(100*Math.min(Math.max(t.position.top/i.DOM.gradient.clientHeight,0),1)),i.DOM.center.style.left=i.centerX+"%",i.DOM.center.style.top=i.centerY+"%",i.DOM.center.classList.remove("is-dragging"),jQuery(e.originalEvent.target).one("click",function(e){e.preventDefault(),e.stopPropagation()})}}).disableSelection())},t.setGradientCenter=function(e){e.preventDefault(),e.stopPropagation();var t=this.DOM.gradient.getBoundingClientRect();this.centerX=Math.round((e.pageX-t.left)/t.width*100),this.centerY=Math.round((e.pageY-(t.top+window.pageYOffset))/t.height*100),this.DOM.center.style.left=this.centerX+"%",this.DOM.center.style.top=this.centerY+"%",this.setGradient()},t.setCanvas=function(){this.DOM.canvas&&(this.DOM.canvas.width=parseInt(window.getComputedStyle(this.element).getPropertyValue("width")),this.DOM.canvas.height=parseInt(window.getComputedStyle(this.DOM.canvas).getPropertyValue("height")),this.canvas=this.DOM.canvas.getContext("2d"))},t.createPoint=function(e){e.preventDefault(),e.stopPropagation(),e.target!==this.DOM.canvas||19<Object.keys(this.points).length||(this.index++,this.point=this.points[this.index]={color:this.getPointColor(e),position:Math.round((e.clientX-e.target.getBoundingClientRect().left)/this.DOM.holder.clientWidth*100)/100},this.addPoint(this.point),this.activePoint(),this.setGradient(),this.hidePicker())},t.addPoint=function(e){e.DOM=document.createElement("LI"),e.DOM.className="wpgb-gradient-point",e.DOM.style.left=100*e.position+"%",e.DOM.style.background=e.color,e.DOM.appendChild(document.createElement("span")),e.DOM.firstChild.className="wpgb-gradient-point-bg",e.DOM.addEventListener("click",this.events.togglePicker,!1),this.DOM.points.appendChild(e.DOM),this.draggable(e)},t.addPoints=function(){if(this.points){for(var e in this.points)this.points.hasOwnProperty(e)&&(this.addPoint(this.points[e]),this.point||(this.point=this.points[e]));this.activePoint()}},t.selectPoint=function(e){for(var t in this.points)this.points.hasOwnProperty(t)&&this.points[t].DOM===e.target&&(this.point=this.points[t]);this.activePoint()},t.activePoint=function(){for(var e in this.points)this.points.hasOwnProperty(e)&&this.points[e].DOM.classList.remove("wpgb-gradient-point-active");this.color=this.point.color,this.point.DOM.classList.add("wpgb-gradient-point-active"),this.DOM.position.value=Math.round(100*this.point.position)+"%"},t.deletePoint=function(){if(!(Object.keys(this.points).length<3)){for(var e in this.points)if(this.points.hasOwnProperty(e)&&this.points[e].DOM===this.point.DOM){this.removePoint(e);break}this.point=this.points[Object.keys(this.points).slice(-1)[0]],this.hidePicker(),this.activePoint(),this.setGradient()}},t.removePoint=function(e){this.points[e].DOM=this.points[e].DOM.parentNode.removeChild(this.points[e].DOM),this.points[e].DOM=null,delete this.points[e]},t.removePoints=function(){for(var e in this.points)this.points.hasOwnProperty(e)&&this.removePoint(e)},t.getPointColor=function(e){e.preventDefault(),e.stopPropagation();e=e.pageX-e.target.getBoundingClientRect().left,e=this.canvas.getImageData(e,0,1,1).data;return"rgba("+e[0]+","+e[1]+","+e[2]+", "+Math.round(e[3]/255*100)/100+")"},t.reversePoints=function(e){for(var t in e.preventDefault(),e.stopPropagation(),this.points)this.points.hasOwnProperty(t)&&(this.points[t].position=1-this.points[t].position,this.points[t].DOM.style.left=100*this.points[t].position+"%");this.DOM.position.value=Math.round(100*this.point.position)+"%",this.setGradient()},t.showPresets=function(e){e.preventDefault(),e.stopPropagation();var t=document.createDocumentFragment();this.DOM.presetsHolder=document.createElement("UL"),this.DOM.presetsHolder.className="wpgb-gradient-presets-holder";for(var i=0;i<s.length;i++)this.DOM.preset=document.createElement("LI"),this.DOM.preset.className="wpgb-gradient-preset",this.DOM.preset.style.background=s[i],t.appendChild(this.DOM.preset);this.DOM.presetsHolder.appendChild(t),this.DOM.holder.appendChild(this.DOM.presetsHolder),this.DOM.presetsHolder.addEventListener("click",this.setPreset.bind(this),!1)},t.removePresets=function(){this.DOM.presetsHolder&&(this.DOM.presetsHolder=this.DOM.presetsHolder.parentNode.removeChild(this.DOM.presetsHolder),this.DOM.presetsHolder=null)},t.setPreset=function(e){"LI"===e.target.tagName&&(e=[].slice.call(e.target.parentNode.children).indexOf(e.target),this.DOM.input.value=s[e],this.dispatchEvent(this.DOM.input,"change"),this.render())},t.togglePicker=function(e){e.preventDefault(),e.stopPropagation(),e.target!==this.point.DOM&&e.target!==this.DOM.color?(this.hidePicker(),this.selectPoint(e)):"none"===this.DOM.iris.style.display?this.showPicker():this.hidePicker()},t.hidePicker=function(){jQuery(this.DOM.iris).iris("hide"),this.DOM.iris.style.display="none",this.DOM.color&&this.DOM.color.classList.remove("wpgb-gradient-point-active"),this.removePresets()},t.showPicker=function(){jQuery(this.DOM.iris).iris("show"),this.iris.wpColorPicker("color",this.color||""),this.DOM.iris.style.display="block",this.DOM.iris.value=this.color||"",this.DOM.color&&this.DOM.color.classList.add("wpgb-gradient-point-active")},t.setGradient=function(){this.gradientColor="",this.canvas.clearRect(0,0,this.canvas.canvas.width,this.canvas.canvas.height),this.canvas.fillStyle="rgba(0, 0, 0, 0)",this.canvas.fillRect(0,0,this.canvas.canvas.width,this.canvas.canvas.height);var e=this.canvas.createLinearGradient(0,0,this.canvas.canvas.width,0);if(this.points){"linear"===this.gradientType?(this.gradientColor+="linear-gradient(",this.gradientColor+=this.angle+"deg, "):(this.gradientColor+="radial-gradient(circle at ",this.gradientColor+=this.centerX+"% ",this.gradientColor+=this.centerY+"%, ");var t,i,s=this.points;for(t in s=Object.keys(s).sort(function(e,t){return s[e].position-s[t].position}))s.hasOwnProperty(t)&&(t=s[t],i=Math.min(Math.max(this.points[t].position,0),1),this.gradientColor+=this.points[t].color+" ",this.gradientColor+=Math.round(100*i)+"%, ",this.points[t].color)&&e.addColorStop(i,this.points[t].color);this.gradientColor=this.gradientColor.slice(0,-2),this.gradientColor+=")",this.canvas.fillStyle=e,this.canvas.fillRect(0,0,this.canvas.canvas.width,this.canvas.canvas.height),this.DOM.gradient.style.background=this.gradientColor,this.DOM.preview.style.background=this.gradientColor,this.DOM.input.value!==this.gradientColor&&(this.DOM.input.value=this.gradientColor,this.dispatchEvent(this.DOM.input,"change"))}},t.draggable=function(i){var s,n=this;jQuery(i.DOM).draggable({scroll:!1,revert:150,axis:"x",containment:"parent",start:function(e){n.hidePicker(),n.selectPoint(e),i.DOM.removeEventListener("click",n.events.togglePicker,!1)},drag:function(e,t){s=Math.round(100*Math.min(Math.max(t.position.left/n.DOM.holder.clientWidth,0),1)),i.position=s/100,t.position.left=i.position*n.DOM.holder.clientWidth,n.DOM.position.value=s+"%",n.setGradient()},stop:function(e,t){s=Math.round(100*Math.min(Math.max(t.position.left/n.DOM.holder.clientWidth,0),1)),i.position=s/100,i.DOM.style.left=s+"%",n.DOM.position.value=s+"%",i.DOM.addEventListener("click",n.events.togglePicker,!1),jQuery(e.originalEvent.target).one("click",function(e){e.preventDefault(),e.stopPropagation()})}}).disableSelection()},t.addPicker=function(){var i=this;this.iris=jQuery(this.DOM.iris).wpColorPicker({__:1,change:function(e,t){"solid"===i.colorType?(i.color=i.solidColor=i.DOM.input.value=i.DOM.preview.style.background=t.color.toString(),i.dispatchEvent(i.DOM.input,"change")):i.point&&(i.color=i.point.color=i.point.DOM.style.background=t.color.toString(),i.setGradient()),i.element.classList.contains("is-dragging")||setTimeout(function(){i.switchIris()},10)},stop:function(){i.switchIris()}}),this.irisSquare=jQuery(this.element.querySelector(".iris-square-value")).draggable({start:function(){i.element.classList.add("is-dragging")},stop:function(){i.element.classList.remove("is-dragging"),i.switchIris()}}),jQuery(this.element.querySelectorAll(".iris-slider-offset")).slider({stop:function(e){jQuery(e.originalEvent.target).one("click",function(e){e.preventDefault(),e.stopPropagation()})}})},t.switchIris=function(){this.irisSquare&&.7<this.irisSquare[0].offsetLeft/this.DOM.wrapper.clientWidth?this.element.classList.add("wpgb-color-position-left"):this.irisSquare&&this.element.classList.remove("wpgb-color-position-left")},e}),function(){for(var e=document.querySelectorAll(".wpgb-color"),t=0,i=e.length;t<i;t++)new WPGB_Gradient(e[t],wpgb_colorPicker_L10n)}),togglePasswordField=(WPGB_Gradient_Init(),function(e){var t;"svg"===e.target.tagName&&(e=e.target.previousElementSibling)&&e.classList&&e.classList.contains("wpgb-password")&&(t=e.getAttribute("type"),e.setAttribute("type","text"===t?"password":"text"))}),WPGB_Popup_Message=(document.body.addEventListener("click",togglePasswordField,!1),function(e,t,i){var s=document.querySelector(".wpgb-popup"),n=wpgb_popup_L10n;i||n.hasOwnProperty(e)?(clearTimeout(WPGB_Popup_Timer),s.lastElementChild.innerHTML=i||n[e],s.className="wpgb-popup wpgb-"+t+" wpgb-show","loading"!==t&&(WPGB_Popup_Timer=setTimeout(function(){s.classList.remove("wpgb-show")},1800))):"success"!==t&&"error"!==t||(s.className="wpgb-popup")}),WPGB_Query_String={get:function(e){var t={};return window.location.search.substr(1).split("&").forEach(function(e){e=e.split("="),t[decodeURIComponent(e[0])]=1<e.length?decodeURIComponent(e[1]):""}),e?t.hasOwnProperty(e)?t[e]:void 0:t},set:function(e){var t,i,s,n={},o=decodeURI(window.location.search);for(t in o.substr(1).split("&").forEach(function(e){e=e.split("="),n[decodeURIComponent(e[0])]=1<e.length?decodeURIComponent(e[1]):""}),e)e.hasOwnProperty(t)&&(i=encodeURIComponent(e[t]),o=n.hasOwnProperty(t)?(s=n[t],i?o.replace(t+"="+s,t+"="+i):(o=o.replace("&"+t+"="+s,"")).replace(t+"="+s,"")):i?o+(o?"&":"?")+t+"="+i:o.replace(t+"=",""));var r=[location.protocol,"//",location.host,location.pathname].join("");return o=o.substr(1)?o:o.substr(1),encodeURI(r+o)}};!function(n){var e=".wpgb-settings-tabs li";WPGB_Query_String.get("tab");function t(e,t){var i,s=0;switch(e.keyCode){case 37:case 38:s=-1;break;case 39:case 40:s=1}s&&(e.preventDefault(),t)&&(t=e.target,e=s,i=t.parentElement.children,(t=1===e?(t=t.nextElementSibling)||i[0]:(t=t.previousElementSibling)||i[i.length-1]).focus(),t.click())}function i(e){for(var t=e.parentElement.children,i=0,s=t.length;i<s;i++){var n=e===t[i],o=n?"true":"false";t[i].setAttribute("tabindex",n?"0":"-1"),t[i].setAttribute("aria-selected",o)}}n(document).on("keydown",e,function(e){t(e,!1)}),n(document).on("keyup",e,function(e){t(e,!0)}),n(document).on("click",e,function(e){e.preventDefault(),"true"!==this.getAttribute("aria-selected")&&(i(this),a(this),l(this))});var s,o,r,a=function(e){if(e=e.parentElement.parentElement.parentElement.querySelector("#"+e.getAttribute("aria-controls"))){for(var t=e.parentElement.children,i=0,s=t.length;i<s;i++)t[i].setAttribute("hidden","");e.removeAttribute("hidden");e=e.querySelectorAll(".CodeMirror");e.length<1||n(e).each(function(e,t){t.CodeMirror.refresh()})}},l=function(e){var t=n(e).closest(".wpgb-settings-tabs");t&&t[0]!==n("#wpgb:not(.postbox) form .wpgb-settings-tabs").get(0)||(e=e.previousElementSibling?(e=e.getAttribute("aria-controls")).replace("wpgb-","").replace("-tab",""):"",t=WPGB_Query_String.set({tab:e}),window.history.pushState({tab:e},null,t))};n(e).length&&window.addEventListener("popstate",function(e){var t="";(t=(t=e.state&&e.state.tab?document.querySelector('[aria-controls="wpgb-'+e.state.tab+'-tab"]'):t)||document.querySelector(".wpgb-settings-tabs li"))&&(t.focus(),i(t),a(t))}),self.URLSearchParams&&(e=window.location.pathname,s=window.location.search,r=(s=new URLSearchParams(s.slice(1))).get("tab"))&&(o=document.querySelector('[aria-controls="wpgb-'+r+'-tab"]'),r={tab:r},o?o.focus():(r="",s.delete("tab")),window.history.replaceState(r,null,e+"?"+s.toString()))}(jQuery),function(a){a.fn.WPGB_SerializeForm=function(){var o,r,e,t;return!(this.length<1)&&(r=o={},t=function(){if(!this.disabled){var e=this.name.replace(/\[([^\]]+)?\]/g,",$1").split(","),t=e.length-1,i=a(this),s=i.closest('[data-field-condition][style$="none;"]');if(!s.length&&e[0]){for(var n=0;n<t;n++)r=r[e[n]]=r[e[n]]||(""===e[n+1]||"0"===e[n+1]?[]:{});s=i.val();""!==s&&!isNaN(parseFloat(s))&&isFinite(s)&&(s=Number(s)),void 0!==r.length?null!==s&&""!==s&&(Array.isArray(s)?s.forEach(function(e){""!==e&&e==Number(e)&&(e=Number(e)),r.push(e)}):r.push(s)):r[e[t]]=s,r=o}}},this.filter(e=':input[type!="checkbox"][type!="radio"], input:checked').each(t),this.find(e).each(t),o)}}(jQuery);