<?php

namespace EssentialElements;

use function Breakdance\Elements\c;
use function Breakdance\Elements\PresetSections\getPresetSection;

\Breakdance\Elements\PresetSections\PresetSectionsController::getInstance()->register(
    "EssentialElements\\LessFancyBackground",
    c(
        "background",
        "Background",
        [c(
        "color",
        "Color",
        [],
        ['type' => 'color', 'layout' => 'inline'],
        false,
        true,
        [],
      ), c(
        "type",
        "Type",
        [],
        ['type' => 'button_bar', 'layout' => 'vertical', 'items' => ['0' => ['value' => 'image', 'text' => 'Image'], '1' => ['text' => 'Gradient', 'value' => 'gradient']]],
        false,
        false,
        [],
      ), c(
        "image",
        "Image",
        [],
        ['type' => 'wpmedia', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image']],
        true,
        true,
        [],
      ), c(
        "image_size",
        "Image Size",
        [],
        ['type' => 'media_size_dropdown', 'layout' => 'inline', 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image'], 'mediaSizeOptions' => ['imagePropertyPath' => 'design.background.image']],
        true,
        true,
        [],
      ), c(
        "image_settings",
        "Image Settings",
        [c(
        "size",
        "Size",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'cover', 'text' => 'cover'], '1' => ['text' => 'contain', 'value' => 'contain'], '2' => ['text' => 'auto', 'value' => 'auto'], '3' => ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "width",
        "Width",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "height",
        "Height",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "repeat",
        "Repeat",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'repeat', 'text' => 'repeat'], '1' => ['text' => 'norepeat', 'value' => 'no-repeat'], '2' => ['text' => 'repeat-x', 'value' => 'repeat-x'], '3' => ['text' => 'repeat-y', 'value' => 'repeat-y']]],
        true,
        false,
        [],
      ), c(
        "position",
        "Position",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'center top', 'text' => 'center top'], '1' => ['value' => 'center center', 'text' => 'center center'], '2' => ['value' => 'center bottom', 'text' => 'center bottom'], '3' => ['value' => 'left top', 'text' => 'left top'], '4' => ['value' => 'left center', 'text' => 'left center'], '5' => ['value' => 'left bottom', 'text' => 'left bottom'], '6' => ['value' => 'right top', 'text' => 'right top'], '7' => ['value' => 'right center', 'text' => 'right center'], '8' => ['value' => 'right bottom', 'text' => 'right bottom'], '9' => ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "custom_position",
        "Custom Position",
        [],
        ['type' => 'focus_point', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.image_settings.position', 'operand' => 'equals', 'value' => 'custom']],
        true,
        false,
        [],
      ), c(
        "attachment",
        "Attachment",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'scroll', 'text' => 'scroll'], '1' => ['text' => 'fixed', 'value' => 'fixed']]],
        true,
        false,
        [],
      ), c(
        "unset_image_at",
        "Unset Image At",
        [],
        ['type' => 'breakpoint_dropdown', 'layout' => 'inline'],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "gradient",
        "Gradient",
        [],
        ['type' => 'color', 'layout' => 'vertical', 'colorOptions' => ['type' => 'gradientOnly'], 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "gradient_animation",
        "Gradient Animation",
        [c(
        "scale",
        "Scale",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['0' => '%']], 'rangeOptions' => ['min' => 100, 'max' => 500, 'step' => 10]],
        false,
        false,
        [],
      ), c(
        "speed",
        "Speed",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['0' => 's']], 'rangeOptions' => ['min' => 1, 'max' => 20, 'step' => 1]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "overlay",
        "Overlay",
        [c(
        "color",
        "Color",
        [],
        ['type' => 'color', 'layout' => 'inline'],
        false,
        true,
        [],
      ), c(
        "type",
        "Type",
        [],
        ['type' => 'button_bar', 'layout' => 'vertical', 'items' => ['0' => ['value' => 'image', 'text' => 'Image'], '1' => ['text' => 'Gradient', 'value' => 'gradient']]],
        false,
        false,
        [],
      ), c(
        "image",
        "Image",
        [],
        ['type' => 'wpmedia', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']],
        true,
        true,
        [],
      ), c(
        "image_size",
        "Image Size",
        [],
        ['type' => 'media_size_dropdown', 'layout' => 'inline', 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']],
        true,
        true,
        [],
      ), c(
        "image_settings",
        "Image Settings",
        [c(
        "size",
        "Size",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'cover', 'text' => 'cover'], '1' => ['text' => 'contain', 'value' => 'contain'], '2' => ['text' => 'auto', 'value' => 'auto'], '3' => ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "width",
        "Width",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.overlay.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "height",
        "Height",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => 'design.background.overlay.image_settings.size', 'operand' => 'equals', 'value' => 'custom']],
        true,
        true,
        [],
      ), c(
        "repeat",
        "Repeat",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'repeat', 'text' => 'repeat'], '1' => ['text' => 'norepeat', 'value' => 'no-repeat'], '2' => ['text' => 'repeat-x', 'value' => 'repeat-x'], '3' => ['text' => 'repeat-y', 'value' => 'repeat-y']]],
        true,
        false,
        [],
      ), c(
        "position",
        "Position",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'center top', 'text' => 'center top'], '1' => ['value' => 'center center', 'text' => 'center center'], '2' => ['value' => 'center bottom', 'text' => 'center bottom'], '3' => ['value' => 'left top', 'text' => 'left top'], '4' => ['value' => 'left center', 'text' => 'left center'], '5' => ['value' => 'left bottom', 'text' => 'left bottom'], '6' => ['value' => 'right top', 'text' => 'right top'], '7' => ['value' => 'right center', 'text' => 'right center'], '8' => ['value' => 'right bottom', 'text' => 'right bottom'], '9' => ['text' => 'custom', 'value' => 'custom']]],
        true,
        false,
        [],
      ), c(
        "custom_position",
        "Custom Position",
        [],
        ['type' => 'focus_point', 'layout' => 'vertical', 'condition' => ['path' => 'design.background.overlay.image_settings.position', 'operand' => 'equals', 'value' => 'custom']],
        true,
        false,
        [],
      ), c(
        "attachment",
        "Attachment",
        [],
        ['type' => 'dropdown', 'layout' => 'inline', 'items' => ['0' => ['value' => 'scroll', 'text' => 'scroll'], '1' => ['text' => 'fixed', 'value' => 'fixed']]],
        true,
        false,
        [],
      ), c(
        "unset_image_at",
        "Unset Image At",
        [],
        ['type' => 'breakpoint_dropdown', 'layout' => 'inline'],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "gradient",
        "Gradient",
        [],
        ['type' => 'color', 'layout' => 'vertical', 'colorOptions' => ['type' => 'gradientOnly'], 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "gradient_animation",
        "Gradient Animation",
        [c(
        "scale",
        "Scale",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['0' => '%']], 'rangeOptions' => ['min' => 100, 'max' => 500, 'step' => 10]],
        false,
        false,
        [],
      ), c(
        "speed",
        "Speed",
        [],
        ['type' => 'unit', 'layout' => 'vertical', 'unitOptions' => ['types' => ['0' => 's']], 'rangeOptions' => ['min' => 1, 'max' => 20, 'step' => 1]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => 'design.background.overlay.type', 'operand' => 'equals', 'value' => 'gradient']],
        false,
        false,
        [],
      ), c(
        "opacity",
        "Opacity",
        [],
        ['type' => 'number', 'layout' => 'inline', 'rangeOptions' => ['min' => 0, 'max' => 1, 'step' => 0.1]],
        false,
        true,
        [],
      ), c(
        "effects",
        "Effects",
        [getPresetSection(
      "EssentialElements\\filter",
      "Filter",
      "filter",
       ['type' => 'popout']
     ), c(
        "blend_mode",
        "Blend Mode",
        [],
        ['type' => 'dropdown', 'layout' => 'vertical', 'items' => ['0' => ['value' => 'normal', 'text' => 'normal'], '1' => ['value' => 'multiply', 'text' => 'multiply'], '2' => ['value' => 'screen', 'text' => 'screen'], '3' => ['value' => 'overlay', 'text' => 'overlay'], '4' => ['value' => 'darken', 'text' => 'darken'], '5' => ['value' => 'lighten', 'text' => 'lighten'], '6' => ['text' => 'color-dodge', 'value' => 'color-dodge'], '7' => ['text' => 'color-burn', 'value' => 'color-burn'], '8' => ['text' => 'hard-light', 'value' => 'hard-light'], '9' => ['text' => 'soft-light', 'value' => 'soft-light'], '10' => ['text' => 'difference', 'value' => 'difference'], '11' => ['text' => 'exclusion', 'value' => 'exclusion'], '12' => ['text' => 'hue', 'value' => 'hue'], '13' => ['text' => 'saturation', 'value' => 'saturation'], '14' => ['text' => 'color', 'value' => 'color'], '15' => ['text' => 'luminosity', 'value' => 'luminosity']]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout']],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'sectionOptions' => ['type' => 'popout']],
        false,
        false,
        [],
      ), c(
        "transition_duration",
        "Transition Duration",
        [],
        ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['0' => 'ms'], 'defaultType' => 'ms'], 'rangeOptions' => ['min' => 0, 'max' => 9900, 'step' => 100]],
        false,
        false,
        [],
      )],
        ['type' => 'section', 'sectionOptions' => ['preset' => ['slug' => 'EssentialElements\\LessFancyBackground']]],
        false,
        false,
        [],
      ),
    true,
    ['relativePropertyPathsToWhitelistInFlatProps' => ['0' => 'image', '1' => 'overlay.image', '2' => 'image_settings.unset_image_at', '3' => 'image_settings.size', '4' => 'image_settings.height', '5' => 'image_settings.repeat', '6' => 'image_settings.position', '7' => 'image_settings.left', '8' => 'image_settings.top', '9' => 'image_settings.attachment', '10' => 'image_settings.custom_position', '11' => 'image_settings.width', '12' => 'overlay.image_settings.custom_position', '13' => 'image_size', '14' => 'overlay.image_size', '15' => 'overlay.type', '16' => 'image_settings']]
);

