<?php

namespace EssentialElements;

use function Breakdance\Elements\c;
use function Breakdance\Elements\PresetSections\getPresetSection;


\Breakdance\ElementStudio\registerElementForEditing(
    "EssentialElements\\TabContent",
    \Breakdance\Util\getdirectoryPathRelativeToPluginFolder(__DIR__)
);

class TabContent extends \Breakdance\Elements\Element
{
    static function uiIcon()
    {
        return 'AlignJustifyIcon';
    }

    static function tag()
    {
        return 'div';
    }

    static function tagOptions()
    {
        return [];
    }

    static function tagControlPath()
    {
        return "false";
    }

    static function name()
    {
        return 'Tab Content';
    }

    static function className()
    {
        return 'bde-advanced-tabs-content';
    }

    static function category()
    {
        return 'advanced';
    }

    static function badge()
    {
        return false;
    }

    static function slug()
    {
        return get_class();
    }

    static function template()
    {
        return file_get_contents(__DIR__ . '/html.twig');
    }

    static function defaultCss()
    {
        return file_get_contents(__DIR__ . '/default.css');
    }

    static function defaultProperties()
    {
        return false;
    }

    static function defaultChildren()
    {
        return [['slug' => 'EssentialElements\Heading', 'defaultProperties' => ['content' => ['content' => ['text' => 'Tab Content', 'tags' => 'h3']], 'design' => ['spacing' => ['margin_bottom' => ['breakpoint_base' => ['number' => 16, 'unit' => 'px', 'style' => '16px']]]]]], ['slug' => 'EssentialElements\Text']];
    }

    static function cssTemplate()
    {
        $template = file_get_contents(__DIR__ . '/css.twig');
        return $template;
    }

    static function designControls()
    {
        return [c(
            "container",
            "Container",
            [c(
                "background",
                "Background",
                [],
                ['type' => 'color', 'layout' => 'inline', 'colorOptions' => ['type' => 'solidAndGradient']],
                false,
                false,
                [],
            ), getPresetSection(
                "EssentialElements\\spacing_padding_all",
                "Padding",
                "padding",
                ['type' => 'popout']
            ), getPresetSection(
                "EssentialElements\\borders",
                "Borders",
                "borders",
                ['type' => 'popout']
            )],
            ['type' => 'section'],
            false,
            false,
            [],
        ), getPresetSection(
            "EssentialElements\\simpleLayout",
            "Layout",
            "layout",
            ['condition' => ['0' => ['0' => ['path' => 'design.layout', 'operand' => 'is set', 'value' => '']]], 'type' => 'popout']
        ), getPresetSection(
            "EssentialElements\\LayoutV2",
            "Layout",
            "layout_v2",
            ['condition' => ['0' => ['0' => ['path' => 'design.layout', 'operand' => 'is not set', 'value' => '']]], 'type' => 'popout']
        ), c(
            "text_colors",
            "Text Colors",
            [c(
                "headings",
                "Headings",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
                [],
            ), c(
                "text",
                "Text",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
                [],
            ), c(
                "link",
                "Link",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                true,
                [],
            ), c(
                "brand",
                "Brand",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
                [],
            )],
            ['type' => 'section', 'condition' => ['0' => ['0' => ['path' => 'design.text_colors', 'operand' => 'is set', 'value' => '']]]],
            false,
            false,
            [],
        )];
    }

    static function contentControls()
    {
        return [];
    }

    static function settingsControls()
    {
        return [];
    }

    static function dependencies()
    {
        return false;
    }

    static function settings()
    {
        return false;
    }

    static function addPanelRules()
    {
        return false;
    }

    static public function actions()
    {
        return [

            'onCreatedElement' => [[
                'script' => ' window.manageBreakdanceTabs && window.manageBreakdanceTabs().update(\'%%SELECTOR%%\')',
            ],],

            'onActivatedElement' => [[
                'script' => 'window.manageBreakdanceTabs && window.manageBreakdanceTabs().activateTabFromStructurePanel(\'%%SELECTOR%%\')', 'runForAllChildren' => true,
            ],],

            'onMovedElement' => [[
                'script' => ' window.manageBreakdanceTabs && window.manageBreakdanceTabs().update(\'%%SELECTOR%%\')',
            ],],

            'onBeforeDeletingElement' => [[
                'script' => ' window.manageBreakdanceTabs && window.manageBreakdanceTabs().update(\'%%SELECTOR%%\')',
            ],],
        ];
    }

    static function nestingRule()
    {
        return ["type" => "container", "restrictedToBeADirectChildOf" => ['EssentialElements\TabsV2', 'EssentialElements\AdvancedTabs'],];
    }

    static function spacingBars()
    {
        return false;
    }

    static function attributes()
    {
        return false;
    }

    static function experimental()
    {
        return false;
    }

    static function order()
    {
        return 13;
    }

    static function dynamicPropertyPaths()
    {
        return false;
    }

    static function additionalClasses()
    {
        return false;
    }

    static function projectManagement()
    {
        return false;
    }

    static function propertyPathsToWhitelistInFlatProps()
    {
        return ['design.layout.horizontal.vertical_at', 'design.layout_v2.layout', 'design.layout_v2.h_vertical_at', 'design.layout_v2.h_alignment_when_vertical', 'design.layout_v2.a_display'];
    }

    static function propertyPathsToSsrElementWhenValueChanges()
    {
        return false;
    }
}
