<?php

namespace Breakdance\Elements\PresetSections;

use function Breakdance\Elements\c;
use function Breakdance\Elements\controlSection;

PresetSectionsController::getInstance()->register(
    "EssentialElements\\tabs_design",
    controlSection("tabs", "Tabs", [
        c(
            "vertical",
            "Vertical",
            [],
            ['type' => 'toggle', 'layout' => 'inline'],
            false,
            false,
            [],
        ),
        c(
            "tabs_width",
            "Tabs Width",
            [],
            ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['defaultType' => 'px'], 'condition' => ['path' => '%%CURRENTPATH%%.vertical', 'operand' => 'is set']],
            true,
            false,
            [],
        ),
        c(
            "horizontal_at",
            "Horizontal At",
            [],
            ['type' => 'breakpoint_dropdown', 'layout' => 'inline', 'condition' => ['path' => '%%CURRENTPATH%%.vertical', 'operand' => 'is set'], 'breakpointOptions' => ['enableNever' => false]],
            false,
            false,
            [],
        ), c(
            "style",
            "Style",
            [],
            ['type' => 'button_bar', 'layout' => 'vertical', 'items' => ['0' => ['value' => 'tabs', 'text' => 'Tabs'], '1' => ['text' => 'Pills', 'value' => 'pills'], '2' => ['text' => 'Bar', 'value' => 'bar']]],
            false,
            false,
        ),
        c(
            "position_vertical",
            "Position",
            [],
            ['type' => 'button_bar', 'layout' => 'inline', 'condition' => ['path' => '%%CURRENTPATH%%.vertical', 'operand' => 'is set'], 'items' => ['0' => ['value' => 'left', 'text' => 'Left'], '1' => ['text' => 'Right', 'value' => 'right']]],
            false,
            false,
        ),
        c(
            "position",
            "Position",
            [],
            ['type' => 'dropdown', 'layout' => 'inline', 'condition' => ['path' => '%%CURRENTPATH%%.vertical', 'operand' => 'is not set'], 'items' => ['0' => ['value' => 'flex-start', 'text' => 'Left'], '1' => ['text' => 'Center', 'value' => 'center'], '2' => ['text' => 'Right', 'value' => 'flex-end'], '3' => ['text' => 'Full Width', 'value' => 'inherit']]],
            false,
            false,
        ),
        c(
            "space_between",
            "Space Between",
            [],
            ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['defaultType' => 'px'], 'rangeOptions' => ['min' => 0, 'max' => 100, 'step' => 1], 'condition' => ['0' => ['0' => ['path' => '%%CURRENTPATH%%.position', 'operand' => 'not equals', 'value' => 'inherit']], '1' => ['0' => ['path' => '%%CURRENTPATH%%.style', 'operand' => 'not equals', 'value' => 'bar']]]],
            false,
            false,
        ),
        c(
            "space_after",
            "Space After",
            [],
            ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['defaultType' => 'px'], 'rangeOptions' => ['min' => 0, 'max' => 100, 'step' => 1], 'condition' => ['path' => '%%CURRENTPATH%%.position', 'operand' => 'not equals', 'value' => 'inherit']],
            true,
            false,
        ),
        c(
            "bar",
            "Bar",
            [c(
                "separator",
                "Separator",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "radius",
                "Radius",
                [],
                ['type' => 'unit', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "shadow",
                "Shadow",
                [],
                ['type' => 'shadow', 'layout' => 'vertical'],
                false,
                false,
            )],
            ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => '%%CURRENTPATH%%.style', 'operand' => 'equals', 'value' => 'bar']],
            false,
            false,
        ), c(
            "pill_radius",
            "Pill Radius",
            [],
            ['type' => 'unit', 'layout' => 'inline', 'condition' => ['path' => '%%CURRENTPATH%%.style', 'operand' => 'equals', 'value' => 'pills']],
            false,
            false,
        ), c(
            "separator",
            "Separator",
            [c(
                "color",
                "Color",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "width",
                "Width",
                [],
                ['type' => 'unit', 'layout' => 'inline'],
                false,
                false,
            )],
            ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => '%%CURRENTPATH%%.style', 'operand' => 'equals', 'value' => 'tabs']],
            false,
            false,
        ), c(
            "text",
            "Text",
            [
                getPresetSection("EssentialElements\\typography_with_align", 'Typography', 'typography', ['type' => 'popout']),
                c(
                    "hover",
                    "Hover",
                    [],
                    ['type' => 'color', 'layout' => 'inline'],
                    false,
                    false,
                ), c(
                    "active",
                    "Active",
                    [],
                    ['type' => 'color', 'layout' => 'inline'],
                    false,
                    false,
                )],
            ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout']],
            false,
            false,
        ), c(
            "background",
            "Background",
            [c(
                "inactive",
                "Inactive",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "hover",
                "Hover",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "active",
                "Active",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            )],
            ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout']],
            false,
            false,
        ), c(
            "underline",
            "Underline",
            [c(
                "hover",
                "Hover",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "active",
                "Active",
                [],
                ['type' => 'color', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "width",
                "Width",
                [],
                ['type' => 'unit', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "radius",
                "Radius",
                [],
                ['type' => 'unit', 'layout' => 'inline'],
                false,
                false,
            )],
            ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => '%%CURRENTPATH%%.style', 'operand' => 'not equals', 'value' => 'pills']],
            false,
            false,
        ), c(
            "padding",
            "Padding",
            [c(
                "vertical",
                "Vertical",
                [],
                ['type' => 'unit', 'layout' => 'inline'],
                false,
                false,
            ), c(
                "horizontal",
                "Horizontal",
                [],
                ['type' => 'unit', 'layout' => 'inline'],
                false,
                false,
            )],
            ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout']],
            false,
            false,
        ), c(
            "icon",
            "Icon",
            [c(
                "size",
                "Size",
                [],
                ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['0' => 'px'], 'defaultType' => 'px'], 'rangeOptions' => ['min' => 0, 'max' => 100, 'step' => 1], 'condition' => ['path' => 'design.design.align', 'operand' => 'not equals', 'value' => 'none']],
                false,
                false,
            ), c(
                "nudge",
                "Nudge",
                [c(
                    "nudge_x",
                    "Nudge X",
                    [],
                    ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['0' => 'px'], 'defaultType' => 'px'], 'rangeOptions' => ['min' => -20, 'max' => 20, 'step' => 1]],
                    false,
                    false,
                ), c(
                    "nudge_y",
                    "Nudge Y",
                    [],
                    ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['0' => 'px'], 'defaultType' => 'px'], 'rangeOptions' => ['min' => -20, 'max' => 20, 'step' => 1]],
                    false,
                    false,
                )],
                ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout']],
                false,
                false,
            ), c(
                "after_icon",
                "After Icon",
                [],
                ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['0' => 'px'], 'defaultType' => 'px'], 'rangeOptions' => ['min' => 0, 'max' => 32, 'step' => 1]],
                false,
                false,
            )],
            ['type' => 'section', 'sectionOptions' => ['type' => 'popout']],
            false,
            false,
        ), c(
            "responsive",
            "Responsive",
            [c(
                "show_as_dropdown",
                "Show as Dropdown",
                [],
                ['type' => 'toggle', 'layout' => 'inline'],
                false,
                false,
                [],
            ), c(
                "visible_at",
                "Visible At",
                [],
                ['type' => 'breakpoint_dropdown', 'layout' => 'inline', 'condition' => ['path' => '%%CURRENTPATH%%.show_as_dropdown', 'operand' => 'is set']],
                false,
                false,
                [],
            ), c(
                "dropdown_styles",
                "Dropdown Styles",
                [c(
                    "background",
                    "Background",
                    [],
                    ['type' => 'color', 'layout' => 'inline'],
                    false,
                    false,
                    [],
                ), getPresetSection(
                    "EssentialElements\\borders",
                    "Borders",
                    "borders",
                    ['type' => 'popout']
                ), getPresetSection(
                    "EssentialElements\\spacing_padding_all",
                    "Padding",
                    "padding",
                    ['type' => 'popout']
                ), getPresetSection(
                    "EssentialElements\\typography",
                    "Typography",
                    "typography",
                    ['type' => 'popout']
                )],
                ['type' => 'section', 'layout' => 'inline', 'sectionOptions' => ['type' => 'popout'], 'condition' => ['path' => '%%CURRENTPATH%%.show_as_dropdown', 'operand' => 'is set']],
                false,
                false,
                [],
            ), c(
                "show_affordance",
                "Show Affordance",
                [],
                ['type' => 'toggle', 'layout' => 'inline', 'condition' => ['path' => '%%CURRENTPATH%%.show_as_dropdown', 'operand' => 'is not set']],
                false,
                false,
                [],
            ), c(
                "affordance_color",
                "Color",
                [],
                ['type' => 'color', 'layout' => 'inline', 'colorOptions' => ['type' => 'solidOnly'], 'condition' => ['path' => '%%CURRENTPATH%%.show_affordance', 'operand' => 'is set']],
                false,
                false,
                [],
            )],
            ['type' => 'section', 'sectionOptions' => ['type' => 'popout']],
            false,
            false,
            [],
        ), c(
            "transition_effect",
            "Transition Effect",
            [],
            ['type' => 'unit', 'layout' => 'inline', 'unitOptions' => ['types' => ['0' => 'ms']], 'rangeOptions' => ['min' => 0, 'max' => 1000, 'step' => 1]],
            false,
            false,
        )],
    ),
    true,
    ['responsive.visible_at', 'responsive.stack_vertically_at']
);
