<?php

namespace EssentialElements;

use function Breakdance\Elements\c;
use function Breakdance\Elements\PresetSections\getPresetSection;

\Breakdance\Elements\PresetSections\PresetSectionsController::getInstance()->register(
    "EssentialElements\\background",
    c(
        "background",
        "Background",
        [c(
        "color",
        "Color",
        [],
        ['type' => 'color', 'layout' => 'inline'],
        true,
        false,
        [],
      ), c(
        "clip",
        "Clip",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'border-box', 'value' => 'border-box'], '1' => ['text' => 'padding-box', 'value' => 'padding-box'], '2' => ['text' => 'content-box', 'value' => 'content-box']]],
        true,
        false,
        [],
      ), c(
        "layers",
        "Layers",
        [c(
        "type",
        "Type",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'Image', 'value' => 'image'], '1' => ['text' => 'Overlay Color', 'value' => 'overlay_color'], '2' => ['text' => 'Gradient', 'value' => 'gradient'], '3' => ['text' => 'None', 'value' => 'none']]],
        false,
        false,
        [],
      ), c(
        "image",
        "Image",
        [],
        ['type' => 'wpmedia', 'layout' => 'vertical', 'condition' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "size",
        "Size",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'auto', 'value' => 'auto'], '1' => ['text' => 'cover', 'value' => 'cover'], '2' => ['text' => 'contain', 'value' => 'contain'], '3' => ['text' => 'custom...', 'value' => 'custom']], 'condition' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "size_manual_width",
        "Width",
        [],
        ['type' => 'unit', 'condition' => ['path' => '%%CURRENTPATH%%.size', 'operand' => 'equals', 'value' => 'custom']],
        false,
        false,
        [],
      ), c(
        "size_manual_height",
        "Height",
        [],
        ['type' => 'unit', 'condition' => ['path' => '%%CURRENTPATH%%.size', 'operand' => 'equals', 'value' => 'custom']],
        false,
        false,
        [],
      ), c(
        "repeat",
        "Repeat",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'no-repeat', 'value' => 'no-repeat'], '1' => ['text' => 'repeat', 'value' => 'repeat'], '2' => ['text' => 'repeat-x', 'value' => 'repeat-x'], '3' => ['text' => 'repeat-y', 'value' => 'repeat-y']], 'condition' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "attachment",
        "Attachment",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'scroll', 'value' => 'scroll'], '1' => ['text' => 'fixed', 'value' => 'fixed']], 'condition' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "position",
        "Position",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'center', 'value' => 'center'], '1' => ['text' => 'custom...', 'value' => 'custom']], 'condition' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'image']],
        false,
        false,
        [],
      ), c(
        "position_manual_left",
        "Left",
        [],
        ['type' => 'unit', 'condition' => ['path' => '%%CURRENTPATH%%.position', 'operand' => 'equals', 'value' => 'custom']],
        false,
        false,
        [],
      ), c(
        "position_manual_top",
        "Top",
        [],
        ['type' => 'unit', 'condition' => ['path' => '%%CURRENTPATH%%.position', 'operand' => 'equals', 'value' => 'custom']],
        false,
        false,
        [],
      ), c(
        "gradient",
        "Gradient",
        [],
        ['type' => 'color', 'layout' => 'vertical', 'colorOptions' => ['type' => 'gradientOnly'], 'condition' => ['0' => ['0' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'gradient']]]],
        false,
        false,
        [],
      ), c(
        "overlay_color",
        "Overlay Color",
        [],
        ['type' => 'color', 'condition' => ['0' => ['0' => ['path' => '%%CURRENTPATH%%.type', 'operand' => 'equals', 'value' => 'overlay_color']]]],
        false,
        false,
        [],
      ), c(
        "blend",
        "Blend Mode",
        [],
        ['type' => 'dropdown', 'items' => ['0' => ['text' => 'normal', 'value' => 'normal'], '1' => ['text' => 'multiply', 'value' => 'multiply'], '2' => ['text' => 'screen', 'value' => 'screen'], '3' => ['text' => 'overlay', 'value' => 'overlay'], '4' => ['text' => 'darken', 'value' => 'darken'], '5' => ['text' => 'lighten', 'value' => 'lighten'], '6' => ['text' => 'color-dodge', 'value' => 'color-dodge'], '7' => ['text' => 'color-burn', 'value' => 'color-burn'], '8' => ['text' => 'hard-light', 'value' => 'hard-light'], '9' => ['text' => 'soft-light', 'value' => 'soft-light'], '10' => ['text' => 'difference', 'value' => 'difference'], '11' => ['text' => 'exclusion', 'value' => 'exclusion'], '12' => ['text' => 'hue', 'value' => 'hue'], '13' => ['text' => 'saturation', 'value' => 'saturation'], '14' => ['text' => 'color', 'value' => 'color'], '15' => ['text' => 'luminosity', 'value' => 'luminosity']]],
        false,
        false,
        [],
      )],
        ['type' => 'repeater', 'layout' => 'vertical'],
        true,
        false,
        [],
      )],
        ['type' => 'section', 'sectionOptions' => ['type' => 'popout', 'preset' => ['slug' => 'EssentialElements\\background']]],
        false,
        false,
        [],
      ),
    true,
    ['relativeDynamicPropertyPaths' => ['0' => ['accepts' => 'image_url', 'path' => 'layers[].image']], 'codeHelp' => '{{ macros.background(%%TWIG_PATH%%) }}']
);

