<?php

/**
 * Plugin Name: MT Inactive
 * Plugin URI: https://themeover.com/
 * Description: Load CSS & JS Assets without MT being active.
 * Author: Sebastian Webb
 * Version: 1.1
 */

namespace Microthemer;

// Stop direct call
if (!defined( 'ABSPATH')) {
	exit;
}

// Run if Microthemer is not active
if (!defined('MT_IS_ACTIVE')) {

	// Public ajax
	if (is_admin()){
		$ajaxFile = dirname(__FILE__) . '/AjaxPublic.php';
		if (!class_exists('\Microthemer\AjaxPublic') && file_exists($ajaxFile)){
			require_once $ajaxFile;
			new AjaxPublic();
		}
	}

	// Site frontend
	else {
		$file = dirname(__FILE__) . '/AssetLoad.php';

		// Load MT AssetLoad class if it's available, but hasn't been loaded yet
		if (!class_exists('\Microthemer\AssetLoad') && file_exists($file)){
			require_once $file;
			new AssetLoad(true);
		}
	}


}